PSCAD 4.2.0

Settings
 {
 Id = "976141504.1144686310"
 Author = "jayas.jayas"
 Desc = "Parallel Transmission Line using Sequencer"
 Arch = "windows"
 Options = 0
 Build = 19
 Warn = 7
 Check = 15
 Libs = ""
 Source = ""
 RunInfo = 
  {
  Fin = 0.5
  Step = 5e-005
  Plot = 5e-005
  Chat = 0.001
  Brch = 0.0005
  Lat = 100
  Options = 0
  Advanced = 511
  Debug = 0
  StartFile = ""
  OFile = "noname.out"
  SFile = "noname.snp"
  SnapTime = 0.3
  Mruns = 10
  Mrunfile = 0
  StartType = 0
  PlotType = 0
  SnapType = 0
  MrunType = "mrun"
  }


Global_Consts = 
  {
  f = 60.0 [Hz]
  }

 }

Definitions
 {
 Module("Controls")
  {
  Desc = ""
  FileDate = 1144686073
  Nodes = 
   {
   Output("F",36,18)
    {
    Type = Integer
    }
   Input("Flt_en",36,-18)
    {
    Type = Integer
    }
   Input("V",36,0)
    {
    Type = Real
    Dim  = [3]
    }
   Output("B",36,-36)
    {
    Type = Integer
    Dim  = [6]
    }
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Pen(Gray)
   Line(27,28,27,-43)
   Brush(,Silver)
   Rectangle(0,-13,3,0)
   Brush(,Gray)
   Rectangle(-3,-10,6,-7)
   Pen(Black)
   Line(27,18,36,18)
   Line(27,-36,36,-36)
   Line(34,-18,27,-18)
   Pen(ByNode)
   Brush(Hollow)
   Rectangle(-4,-18,7,3)
   Pen(Black)
   Line(27,0,36,0)
   Text(1,25,"Controls")
   }


  Page(B/A3,Landscape,16,[597,467],100)
   {
   -Sticky-([72,612],0)
    {
    Name = ""
    Font = 1
    Bounds = 72,612,180,648
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "FAULT CONTROLS"
    }
   -Wire-([648,684],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([684,684],0,0,-1)
    {
    Name = "Tfs"
    }
   0.datalabel([684,720],0,0,-1)
    {
    Name = "Tfd"
    }
   0.datalabel([1116,1206],4,0,-1)
    {
    Name = "Fault"
    }
   -Wire-([1116,1206],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -ControlPanel-([18,396],0)
    {
    Name = "SOURCE 2"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,576,126
    Slider(62207992)
    Meter(62248528)
    Slider(62205136)
    Meter(62142240)
    Meter(61984792)
    Meter(62011976)
    Meter(62123448)
    Meter(62126360)
    }
   -Sticky-([522,108],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 522,108,684,216
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Adjust phase angle to obtain
the correct power flow. Adjust
voltage to obtain the matching
VAR flow at each end."
    }
   0.arrow_a([522,216],1,0,-1)
    {
    }
   0.datalabel([1512,720],3,0,-1)
    {
    Name = "B3T1"
    }
   0.datalabel([1512,774],3,0,-1)
    {
    Name = "B3T2"
    }
   0.datalabel([1512,828],3,0,-1)
    {
    Name = "B4T1"
    }
   0.datalabel([1350,1008],6,0,-1)
    {
    Name = "B1"
    }
   0.datalabel([1350,1026],6,0,-1)
    {
    Name = "B2"
    }
   0.datalabel([1350,1044],6,0,-1)
    {
    Name = "B3"
    }
   0.datalabel([1350,1062],6,0,-1)
    {
    Name = "B4"
    }
   -Sticky-([1242,144],0)
    {
    Name = ""
    Font = 1
    Bounds = 1242,144,1350,180
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "BREAKER CONTROLS"
    }
   -Wire-([648,720],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -ControlPanel-([1242,252],0)
    {
    Name = "B1 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(45604512)
    Slider(45621928)
    Slider(45615208)
    }
   -ControlPanel-([1242,396],0)
    {
    Name = "B2 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(45607760)
    Slider(45618176)
    Slider(45636792)
    }
   0.datalabel([1512,882],3,0,-1)
    {
    Name = "B4T2"
    }
   -ControlPanel-([1242,774],0)
    {
    Name = "B4 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(45633728)
    Slider(45560000)
    Slider(45556848)
    }
   0.var([1476,882],0,45556848,190)
    {
    Name = "B4T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "0.42"
    Units = "s"
    Collect = "1"
    }
   0.var([1476,828],0,45560000,170)
    {
    Name = "B4T1"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "0.36"
    Units = "s"
    Collect = "1"
    }
   0.var([1476,774],0,45562856,160)
    {
    Name = "B3T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   -Sticky-([18,198],0)
    {
    Name = ""
    Font = 1
    Bounds = 18,198,144,234
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "PREFAULT CONTROLS"
    }
   -ControlPanel-([18,252],0)
    {
    Name = "SOURCE 1"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,576,126
    Slider(62199184)
    Meter(62242872)
    Slider(62202280)
    Meter(62139272)
    Meter(62147984)
    Meter(62015040)
    Meter(62188408)
    Meter(62120536)
    }
   -Wire-([1926,486],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1926,306],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.logic([1962,486],6,0,370)
    {
    Type = "1"
    Inv = "0"
    }
   0.logic([1962,306],0,0,470)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1998,306],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var_switch([1998,270],0,45604512,10)
    {
    Name = "42-B1"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   -Wire-([1998,486],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var_switch([1998,432],6,45607760,60)
    {
    Name = "42-B2"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   -Wire-([2034,450],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.tbreakn([1872,306],4,0,340)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B1T1"
    TO2 = "B1T2"
    }
   0.tbreakn([1872,486],4,0,80)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B2T1"
    TO2 = "B2T2"
    }
   0.datalabel([1512,342],3,0,-1)
    {
    Name = "B1T1"
    }
   0.datalabel([1512,396],3,0,-1)
    {
    Name = "B1T2"
    }
   0.datalabel([1512,450],3,0,-1)
    {
    Name = "B2T1"
    }
   0.var([1476,396],0,45615208,30)
    {
    Name = "B1 T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2"
    Units = "s"
    Collect = "1"
    }
   0.var([1476,450],0,45618176,50)
    {
    Name = "B2 T1"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2"
    Units = "s"
    Collect = "1"
    }
   0.datalabel([1512,504],3,0,-1)
    {
    Name = "B2T2"
    }
   0.var([1476,342],0,45621928,20)
    {
    Name = "B1 T1"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "0.0"
    Value = "2"
    Units = "s"
    Collect = "1"
    }
   -Wire-([1926,882],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1926,702],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1926,738],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   0.logic([1962,882],6,0,210)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1998,702],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var_switch([1998,666],0,45627088,130)
    {
    Name = "42-B3"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   -Wire-([1998,882],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2034,846],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.var([1476,720],0,45630688,140)
    {
    Name = "B3T1"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "0.0"
    Value = "0.32"
    Units = "s"
    Collect = "1"
    }
   0.var_switch([1998,828],6,45633728,180)
    {
    Name = "42-B4"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   -Sticky-([918,108],0)
    {
    Name = ""
    Font = 1
    Bounds = 918,108,1044,144
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "COMTRADE Recorders"
    }
   0.var([1476,504],0,45636792,70)
    {
    Name = "B2 T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2"
    Units = "s"
    Collect = "1"
    }
   0.tbreakn([1872,702],4,0,380)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B3T1"
    TO2 = "B3T2"
    }
   0.logic([2070,450],0,0,490)
    {
    Type = "2"
    Inv = "0"
    }
   -Wire-([1908,396],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.const([900,1458],0,0,320)
    {
    Name = ""
    Value = "360"
    }
   -Wire-([1314,1224],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([810,1224],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([846,1422],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([972,1422],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([1098,1422],0,0,-1)
    {
    Name = "FDelay"
    }
   -Wire-([1062,1422],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([864,1422],0,0,-1)
    {
    Name = "FAngle"
    }
   -Wire-([432,1278],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([666,1278],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([756,1278],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1260,1278],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.var([810,1422],0,45649216,310)
    {
    Name = "FaultAngle"
    Group = ""
    Display = "0"
    Max = "360"
    Min = "0.0"
    Value = "30.0"
    Units = "deg"
    Collect = "1"
    }
   0.div([1026,1422],0,0,460)
    {
    }
   -Wire-([990,1278],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1116,1278],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.const([990,1458],0,0,330)
    {
    Name = "FREQ"
    Value = "$(f)"
    }
   -Wire-([1260,1278],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1512,1278],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1512,1278],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1566,1224],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.import([1476,1026],0,0,220)
    {
    Name = "V"
    }
   -Wire-([1512,1026],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   0.Sequencer_Breaker([612,1278],0,0,270)
    {
    BNAME = "B4seq"
    OpenClos = "0"
    State = "1"
    }
   -Wire-([666,792],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.var_pot([630,792],0,45658152,120)
    {
    Name = "Fault type"
    Group = ""
    Display = "0"
    NDP = "10"
    Value = "7"
    F1 = "1.0"
    F2 = "2.0"
    F3 = "3.0"
    F4 = "4.0"
    F5 = "5.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "0"
    }
   -Wire-([828,792],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.export([1404,1134],4,0,610)
    {
    Name = "B"
    }
   0.datamerge([1368,1080],4,0,580)
    {
    N = "6"
    Type = "1"
    Disp = "1"
    }
   -Wire-([1278,1080],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([900,792],0,0,-1)
    {
    Name = "Faultloc"
    }
   0.datalabel([1314,1098],0,0,-1)
    {
    Name = "Faultloc"
    }
   -Wire-([1314,1098],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1278,1080],0,0,-1)
    {
    Name = "FaultType"
    }
   0.var_switch([684,1368],0,45667000,300)
    {
    Name = "Seq. Enable"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "Enab"
    Toff = "Off"
    }
   -Wire-([720,1314],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.logic([1962,702],0,0,390)
    {
    Type = "1"
    Inv = "0"
    }
   0.datalabel([720,1350],3,0,-1)
    {
    Name = "Seq_enable"
    }
   -Wire-([1926,342],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   0.div([936,1422],0,0,450)
    {
    }
   -Wire-([414,1278],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.Sequencer_Start([360,1278],0,0,250)
    {
    loop = "0"
    State = "1"
    }
   -Sticky-([1386,144],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 1386,144,1548,216
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Adjust breaker clearing time (T1)
and reclose time (T2) if needed."
    }
   0.tbreakn([1872,882],4,0,200)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B4T1"
    TO2 = "B4T2"
    }
   -ControlPanel-([72,648],0)
    {
    Name = "Fault Location, Type, Start & Duration"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,432,126
    Dial(45717072)
    Dial(45658152)
    Slider(45713320)
    Slider(45710512)
    Slider(62270136)
    }
   0.Sequencer_Breaker([504,1278],0,0,260)
    {
    BNAME = "B3seq"
    OpenClos = "0"
    State = "1"
    }
   0.mult([720,1278],0,0,420)
    {
    }
   0.Sequencer_Wait([936,1278],0,0,440)
    {
    WaitType = "3"
    CrossDir = "1"
    FixedDelay = "1.0 [s]"
    Min = "0.0 [s]"
    Max = "1.0 [s]"
    UntilTime = "TStart"
    CrossValue = "0.0"
    CrossSig = "V1a"
    State = "1"
    }
   0.datatap([1620,1044],0,0,230)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1620,1044],0,0,-1)
    {
    Name = "V1a"
    }
   0.var([612,720],0,45710512,100)
    {
    Name = "Duration "
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.2"
    Units = ""
    Collect = "1"
    }
   0.var([612,684],0,45713320,90)
    {
    Name = "Fault Start "
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.2"
    Units = "s"
    Collect = "1"
    }
   0.datalabel([738,792],0,0,-1)
    {
    Name = "FaultType"
    }
   0.var_pot([792,792],0,45717072,150)
    {
    Name = "Fault Location "
    Group = ""
    Display = "0"
    NDP = "6"
    Value = "5"
    F1 = "1.0"
    F2 = "2.0"
    F3 = "3.0"
    F4 = "4.0"
    F5 = "5.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "10.0"
    }
   -Sticky-([72,810],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 72,810,234,1116
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Dial Position:
  1=> FT1:
          Between Source
          and  B1
  2=> FT2: 
          Between B1 
          and Line
  3=> FT3: 
          Between Line 1
          and B2
  4=> FT4: 
          Between Source
          and B2
  5=> FT5:
          Between B3
          and Line 2
  6=> FT6:
          Between Line 2 
          and B4  "
    }
   -Sticky-([270,810],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 270,810,396,1008
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Dial Position:
  1=> A-g
  2=> B-g
  3=> C-g
  4=> AB-g
  5=> AC-g
  6=> BC-g
  7=> ABC-g
  8=> AB 
  9=> AC 
10=>No Fault 
11=> No fault (0)"
    }
   0.Sequencer_Wait([828,1278],0,0,430)
    {
    WaitType = "2"
    CrossDir = "1"
    FixedDelay = "1.0 [s]"
    Min = "0.0 [s]"
    Max = "1.0 [s]"
    UntilTime = "StartTime"
    CrossValue = "0.0"
    CrossSig = "Va"
    State = "1"
    }
   0.datalabel([846,1224],0,0,-1)
    {
    Name = "StartTime"
    }
   0.var([774,1224],0,45723976,240)
    {
    Name = "StartTime"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.2"
    Units = "s"
    Collect = "1"
    }
   -ControlPanel-([486,1008],0)
    {
    Name = "Sequence Control "
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,360,126
    Slider(45723976)
    Switch(45667000)
    Slider(45649216)
    Slider(45762160)
    Slider(45765128)
    }
   0.datalabel([1350,1224],0,0,-1)
    {
    Name = "ProtTime"
    }
   0.var([1278,1224],0,45762160,280)
    {
    Name = "Prot Time"
    Group = ""
    Display = "0"
    Max = "0.1"
    Min = "0.0"
    Value = "0.032"
    Units = "s"
    Collect = "1"
    }
   0.var([1530,1224],0,45765128,290)
    {
    Name = "Prot Delay"
    Group = ""
    Display = "0"
    Max = "0.1"
    Min = "0.0"
    Value = "0.014"
    Units = "s"
    Collect = "1"
    }
   0.datalabel([1602,1224],0,0,-1)
    {
    Name = "ProtDelay"
    }
   0.Sequencer_Wait([1584,1278],0,0,540)
    {
    WaitType = "0"
    CrossDir = "1"
    FixedDelay = "ProtDelay"
    Min = "0.0 [s]"
    Max = "1.0 [s]"
    UntilTime = "1.0 [s]"
    CrossValue = "0.0"
    CrossSig = "Va"
    State = "1"
    }
   0.Sequencer_Wait([1062,1278],0,0,500)
    {
    WaitType = "0"
    CrossDir = "1"
    FixedDelay = "FDelay"
    Min = "0.0 [s]"
    Max = "1.0 [s]"
    UntilTime = "TStart"
    CrossValue = "0.0"
    CrossSig = "Va"
    State = "1"
    }
   -Sticky-([486,846],0)
    {
    Name = ""
    Font = 1
    Bounds = 486,846,864,990
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Enabling sequence control allows PSCAD/Relay to control the breakers.

Fault Angle determines the time after a positive crossing of A's Phase Voltage 
Prot Time is the delay representing  breaker 3 and 4 operating time. 
Prot Delay represents communication time between breaker location 3 and 4. "
    }
   -ControlPanel-([1242,630],0)
    {
    Name = "B3 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(45627088)
    Slider(45630688)
    Slider(45562856)
    }
   -Sticky-([1278,954],0)
    {
    Name = ""
    Font = 1
    Bounds = 1278,954,1386,990
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Exports to Main Page"
    }
   -ControlPanel-([846,306],0)
    {
    Name = "Recorder Control"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,288,126
    Switch(62316320)
    Switch(62301632)
    Switch(62319040)
    Switch(62321760)
    }
   -ControlPanel-([918,162],0)
    {
    Name = "Recorders"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,144,126
    Slider(61885992)
    Slider(62308968)
    }
   0.export([1206,1206],4,0,600)
    {
    Name = "F"
    }
   0.datalabel([972,738],0,0,-1)
    {
    Name = "Seq_enable"
    }
   -Wire-([864,666],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([864,666],2,0,-1)
    {
    Name = "Faultseq"
    }
   -Wire-([1008,702],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1044,702],2,0,-1)
    {
    Name = "Fault"
    }
   0.select([972,702],0,0,590)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([864,702],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([864,702],4,0,-1)
    {
    Name = "Fault1"
    }
   0.tfaultn([828,702],4,0,110)
    {
    TF = "Tfs"
    DF = "Tfd"
    }
   0.Sequencer_Fault([1188,1278],0,0,510)
    {
    FNAME = "Faultseq"
    AppRem = "1"
    State = "1"
    }
   0.datalabel([2250,846],2,0,-1)
    {
    Name = "B4"
    }
   -Wire-([2106,702],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2106,846],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.Sequencer_Breaker([1692,1278],0,0,550)
    {
    BNAME = "B4seq"
    OpenClos = "1"
    State = "1"
    }
   0.Sequencer_Wait([1332,1278],0,0,520)
    {
    WaitType = "0"
    CrossDir = "1"
    FixedDelay = "ProtTime"
    Min = "0.0 [s]"
    Max = "1.0 [s]"
    UntilTime = "1.0 [s]"
    CrossValue = "0.0"
    CrossSig = "Va"
    State = "1"
    }
   0.Sequencer_Breaker([1440,1278],0,0,530)
    {
    BNAME = "B3seq"
    OpenClos = "1"
    State = "1"
    }
   -Wire-([2214,702],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.logic([2070,702],6,0,400)
    {
    Type = "2"
    Inv = "0"
    }
   0.select([2178,702],0,0,570)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.datalabel([2250,702],4,0,-1)
    {
    Name = "B3"
    }
   -Wire-([2142,630],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.datalabel([2142,630],1,0,-1)
    {
    Name = "B3seq"
    }
   0.datalabel([2178,738],0,0,-1)
    {
    Name = "Seq_enable"
    }
   0.datalabel([2178,810],2,0,-1)
    {
    Name = "Seq_enable"
    }
   0.logic([2070,846],0,0,410)
    {
    Type = "2"
    Inv = "0"
    }
   -Wire-([2142,882],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.datalabel([2142,918],0,0,-1)
    {
    Name = "B4seq"
    }
   -Wire-([2214,846],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Sticky-([864,450],0)
    {
    Name = ""
    Font = 1
    Bounds = 864,450,1116,540
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
To turn the Recorders on, click on the switch.
On = Recorder will record data.
Off = Recorder will NOT record data.

You can turn on or off each recorder individually."
    }
   -Wire-([1692,432],0,0,-1)
    {
    Vertex="0,0;0,360"
    }
   0.import([1638,432],0,0,40)
    {
    Name = "Flt_en"
    }
   -Wire-([1674,432],0,0,-1)
    {
    Vertex="0,0;162,0"
    }
   0.logic([2070,306],6,0,480)
    {
    Type = "2"
    Inv = "0"
    }
   -Wire-([1764,396],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.logic([1872,396],0,0,360)
    {
    Type = "1"
    Inv = "0"
    }
   0.inv([1800,396],0,0,350)
    {
    INTR = "0"
    }
   0.datalabel([1764,396],2,0,-1)
    {
    Name = "Seq_enable"
    }
   0.datalabel([2106,306],4,0,-1)
    {
    Name = "B1"
    }
   0.datalabel([2106,450],2,0,-1)
    {
    Name = "B2"
    }
   -Sticky-([2142,306],0)
    {
    Name = ""
    Font = 1
    Bounds = 2142,306,2322,468
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Note:
There is no control for B1 and B2
by the sequencer.  

To add it in, remove the Seq_enable 
signal and AND gate.

Add a switch, similar to B3 and B4.

Add in the control component in the 
sequencer line, similar to B3 and B4."
    }
   -Wire-([1692,792],0,0,-1)
    {
    Vertex="0,0;234,0"
    }
   0.select([2178,846],6,0,560)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Divider-([0,594],0)
    {
    Size(1152,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([1152,936],0)
    {
    Size(1224,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([1152,54],0)
    {
    Size(0,1062)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([792,54],0)
    {
    Size(0,540)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   }
  }
 Module("Plots_B2")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Line(-13,-1,-13,-21)
   Line(-13,-4,-4,-13)
   Line(-4,-13,1,-10)
   Line(6,-16,12,-13)
   Pen(Gray)
   Line(27,28,27,-43)
   Pen(Black)
   Line(1,-10,6,-16)
   Line(-18,-4,21,-4)
   Text(1,-28,"Plots")
   Text(3,24,"B2 B4")
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Plot-([18,36],0)
    {
    Title = "Plots at B2"
    Draw = 1
    Area = [0,0,738,1152]
    Posn = [18,36]
    Icon = [-1,-1]
    Extents = 0,0,738,1152
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,738,277],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(61947000,"V2a",0,,,)
     Curve(61949912,"V2b",1,,,)
     Curve(61976912,"V2c",2,,,)
     }
    Graph([0,277],[0,0,738,277],"Current")
     {
     Options = 9
     Units = ""
     Curve(61938344,"I2a",0,,,)
     Curve(61941176,"I2b",1,,,)
     Curve(62031368,"I2c",2,,,)
     }
    Graph([0,554],[0,0,738,277],"Current")
     {
     Options = 9
     Units = ""
     Curve(62028424,"I20",0,,,)
     }
    PGraph([0,831],[0,0,738,258],"PolyGraph")
     {
     Options = 2
     Curve(61956896,"Br2a",0,,,)
     Curve(61968816,"Br2b",1,,,)
     Curve(61959592,"Br2c",2,,,)
     }
    }
   -Plot-([792,36],0)
    {
    Title = "Plots at B4"
    Draw = 1
    Area = [0,0,738,1152]
    Posn = [792,36]
    Icon = [-1,-1]
    Extents = 0,0,738,1152
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,738,277],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(62090376,"V4a",0,,,)
     Curve(62093288,"V4b",1,,,)
     Curve(62263024,"V4c",2,,,)
     }
    Graph([0,277],[0,0,738,277],"Current")
     {
     Options = 9
     Units = ""
     Curve(62096376,"I4a",0,,,)
     Curve(62103560,"I4b",1,,,)
     Curve(62106184,"I4c",2,,,)
     }
    Graph([0,554],[0,0,738,277],"Current")
     {
     Options = 9
     Units = ""
     Curve(62109096,"I40",0,,,)
     }
    PGraph([0,831],[0,0,738,258],"PolyGraph")
     {
     Options = 2
     Curve(61856992,"Br4a",0,,,1)
     Curve(62129272,"Br4b",1,,,1)
     Curve(62132048,"Br4c",2,,,1)
     }
    }
   }
  }
 Module("Plots_B1")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Line(-13,-1,-13,-21)
   Line(-18,-4,21,-4)
   Line(-13,-4,-4,-13)
   Line(-4,-13,1,-10)
   Line(6,-16,12,-13)
   Pen(Gray)
   Line(27,28,27,-43)
   Pen(Black)
   Line(1,-10,6,-16)
   Text(1,-28,"Plots")
   Text(3,24,"B1 B3")
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Plot-([18,18],0)
    {
    Title = "Plots at B1"
    Draw = 1
    Area = [0,0,738,1170]
    Posn = [18,18]
    Icon = [-1,-1]
    Extents = 0,0,738,1170
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,738,282],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(62136360,"V1a",0,,,)
     Curve(61963264,"V1b",1,,,)
     Curve(61944088,"V1c",2,,,)
     }
    Graph([0,282],[0,0,738,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(62017952,"I1a",0,,,)
     Curve(62034336,"I1b",1,,,)
     Curve(62020864,"I1c",2,,,)
     }
    Graph([0,563],[0,0,738,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(62024616,"I10",0,,,)
     }
    PGraph([0,844],[0,0,738,263],"PolyGraph")
     {
     Options = 2
     Curve(62265992,"Br1a",0,,,)
     Curve(61966040,"Br1b",1,,,)
     Curve(62007136,"Br1c",2,,,)
     }
    }
   -Plot-([810,18],0)
    {
    Title = "Plots at B3"
    Draw = 1
    Area = [0,0,738,1170]
    Posn = [810,18]
    Icon = [-1,-1]
    Extents = 0,0,738,1170
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,738,282],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(62069952,"V3a",0,,,)
     Curve(62072728,"V3b",1,,,)
     Curve(62075648,"V3c",2,,,)
     }
    Graph([0,282],[0,0,738,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(62078560,"I3a",0,,,)
     Curve(62081472,"I3b",1,,,)
     Curve(62084552,"I3c",2,,,)
     }
    Graph([0,563],[0,0,738,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(62087464,"I30",0,,,)
     }
    PGraph([0,844],[0,0,738,263],"PolyGraph")
     {
     Options = 2
     Curve(62112008,"Br3a",0,,,1)
     Curve(62114784,"Br3b",1,,,1)
     Curve(62117760,"Br3c",2,,,1)
     }
    }
   }
  }
 Module("Main")
  {
  Desc = "Main Page"
  FileDate = 1144686073
  Nodes = 
   {
   }

  Graphics = 
   {
   Rectangle(-18,-18,18,18)
   }


  Page(B/A3,Landscape,16,[597,467],100)
   {
   0.pgb([2250,1242],0,61856992,1110)
    {
    Name = "Br4a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.datalabel([486,1152],2,0,-1)
    {
    Name = "I1A"
    }
   0.datalabel([522,1152],2,0,-1)
    {
    Name = "I1B"
    }
   0.datalabel([558,1152],2,0,-1)
    {
    Name = "I1C"
    }
   0.datalabel([486,1332],2,0,-1)
    {
    Name = "I2A"
    }
   0.datalabel([522,1332],2,0,-1)
    {
    Name = "I2B"
    }
   0.datalabel([558,1332],2,0,-1)
    {
    Name = "I2C"
    }
   -Wire-([1818,1206],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datatap([1836,1242],0,0,280)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1836,1278],0,0,380)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([378,1152],2,0,-1)
    {
    Name = "V1A"
    }
   0.datalabel([414,1152],2,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([450,1152],2,0,-1)
    {
    Name = "V1C"
    }
   0.datalabel([378,1332],6,0,-1)
    {
    Name = "V2A"
    }
   0.datalabel([414,1332],6,0,-1)
    {
    Name = "V2B"
    }
   0.datalabel([450,1332],6,0,-1)
    {
    Name = "V2C"
    }
   -Wire-([2214,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2214,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2214,1314],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2214,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1980,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1980,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1980,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1854,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1854,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1854,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2088,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2088,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2088,1314],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2088,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2088,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datatap([1962,1314],0,0,470)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1962,1278],0,0,420)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1962,1242],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1962,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1962,1314],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1836,1314],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1836,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1836,1242],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datatap([1836,1314],0,0,450)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1962,1242],0,0,330)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1944,1206],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.var([108,1260],0,61885992,150)
    {
    Name = "Start"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.15"
    Units = "s"
    Collect = "1"
    }
   0.datalabel([1170,1134],2,0,-1)
    {
    Name = "B2"
    }
   0.datalabel([1080,1224],2,0,-1)
    {
    Name = "FT1"
    }
   0.datalabel([1116,1224],2,0,-1)
    {
    Name = "FT2"
    }
   0.datalabel([1152,1224],2,0,-1)
    {
    Name = "FT3"
    }
   -Wire-([1134,1314],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   0.datalabel([1080,1476],0,0,-1)
    {
    Name = "F1"
    }
   0.datalabel([1116,1476],0,0,-1)
    {
    Name = "F2"
    }
   0.datalabel([1152,1476],0,0,-1)
    {
    Name = "F3"
    }
   0.datalabel([1170,1386],2,0,-1)
    {
    Name = "Fault"
    }
   -Wire-([1980,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1854,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([810,738],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([342,630],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datalabel([360,738],0,0,-1)
    {
    Name = "FT1"
    }
   0.datalabel([360,756],0,0,-1)
    {
    Name = "F1"
    }
   0.pgb([2376,1314],0,61903264,500)
    {
    Name = "V3rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.pgb([2376,1350],0,61906040,510)
    {
    Name = "V4rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.datalabel([792,540],0,0,-1)
    {
    Name = "FT3"
    }
   0.datalabel([792,558],0,0,-1)
    {
    Name = "F3"
    }
   0.datalabel([792,774],0,0,-1)
    {
    Name = "FT6"
    }
   0.datalabel([792,792],0,0,-1)
    {
    Name = "F6"
    }
   0.datalabel([1206,1134],2,0,-1)
    {
    Name = "B3"
    }
   0.datalabel([1134,1134],2,0,-1)
    {
    Name = "B1"
    }
   0.datalabel([1224,1224],2,0,-1)
    {
    Name = "FT5"
    }
   0.datalabel([1260,1476],0,0,-1)
    {
    Name = "F6"
    }
   0.breaker3([918,522],0,0,670)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B2"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I2A"
    IBRB = "I2B"
    IBRC = "I2C"
    IBR0 = "I20"
    SBRA = "Br2A"
    SBRB = "Br2B"
    SBRC = "Br2C"
    BP = "P2"
    BQ = "Q2"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "116.7 [MW]"
    Q = "-18.47 [MVAR]"
    }
   0.datalabel([576,540],0,0,-1)
    {
    Name = "FT2"
    }
   0.datalabel([576,558],0,0,-1)
    {
    Name = "F2"
    }
   0.datalabel([576,774],0,0,-1)
    {
    Name = "FT5"
    }
   -Wire-([558,738],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   0.breaker3([450,522],4,0,680)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B1"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I1A"
    IBRB = "I1B"
    IBRC = "I1C"
    IBR0 = "I10"
    SBRA = "Br1A"
    SBRB = "Br1B"
    SBRC = "Br1C"
    BP = "P1"
    BQ = "Q1"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "-114.8 [MW]"
    Q = "14.62 [MVAR]"
    }
   -Wire-([522,522],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([720,1440],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([324,1440],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([720,1260],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([1368,1368],0,0,-1)
    {
    Name = "I1A"
    }
   0.datalabel([1368,1404],0,0,-1)
    {
    Name = "I1B"
    }
   0.datalabel([1368,1440],0,0,-1)
    {
    Name = "I1C"
    }
   0.datalabel([1494,1368],0,0,-1)
    {
    Name = "I2A"
    }
   0.datalabel([1494,1404],0,0,-1)
    {
    Name = "I2B"
    }
   0.pgb([1530,1368],0,61938344,1030)
    {
    Name = "I2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([1530,1404],0,61941176,960)
    {
    Name = "I2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([1404,1314],0,61944088,360)
    {
    Name = "V1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([1530,1242],0,61947000,230)
    {
    Name = "V2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([1530,1278],0,61949912,310)
    {
    Name = "V2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.datalabel([1602,1242],0,0,-1)
    {
    Name = "Br1A"
    }
   0.datalabel([1602,1278],0,0,-1)
    {
    Name = "Br1B"
    }
   0.datalabel([1602,1314],0,0,-1)
    {
    Name = "Br1C"
    }
   0.datalabel([1728,1242],0,0,-1)
    {
    Name = "Br2A"
    }
   0.datalabel([1728,1278],0,0,-1)
    {
    Name = "Br2B"
    }
   0.pgb([1764,1242],0,61956896,1160)
    {
    Name = "Br2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([1764,1314],0,61959592,1060)
    {
    Name = "Br2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([1602,1368],0,0,-1)
    {
    Name = "P1"
    }
   0.pgb([1404,1278],0,61963264,260)
    {
    Name = "V1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([1638,1278],0,61966040,1150)
    {
    Name = "Br1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([1764,1278],0,61968816,1130)
    {
    Name = "Br2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datatap([1350,1242],0,0,190)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1350,1278],0,0,250)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1332,1206],2,0,-1)
    {
    Name = "V1"
    }
   0.datalabel([1368,1242],2,0,-1)
    {
    Name = "V1A"
    }
   0.datalabel([1368,1278],2,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([1494,1278],2,0,-1)
    {
    Name = "V2B"
    }
   0.pgb([1530,1314],0,61976912,400)
    {
    Name = "V2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   -Wire-([1602,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1602,1440],0,0,-1)
    {
    Name = "S1W"
    }
   -Wire-([1602,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1602,1476],0,0,-1)
    {
    Name = "S1Q"
    }
   -Wire-([1728,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1728,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1728,1476],0,0,-1)
    {
    Name = "S2Q"
    }
   0.datalabel([1494,1242],2,0,-1)
    {
    Name = "V2A"
    }
   0.pgb([1764,1368],0,61984792,980)
    {
    Name = "P2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   0.datalabel([1728,1440],0,0,-1)
    {
    Name = "S2W"
    }
   -Wire-([1728,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1728,1404],0,0,-1)
    {
    Name = "Q2"
    }
   -Wire-([1728,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1728,1368],0,0,-1)
    {
    Name = "P2"
    }
   -Wire-([1728,1314],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1728,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1728,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1728,1314],0,0,-1)
    {
    Name = "Br2C"
    }
   0.datalabel([1494,1440],0,0,-1)
    {
    Name = "I2C"
    }
   -Wire-([1494,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1494,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1494,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1368,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1368,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1368,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1602,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1602,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1602,1314],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1602,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1602,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1494,1314],2,0,-1)
    {
    Name = "V2C"
    }
   0.datatap([1476,1314],0,0,370)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1476,1278],0,0,270)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1476,1242],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1476,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1476,1314],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([1368,1314],2,0,-1)
    {
    Name = "V1C"
    }
   -Wire-([1350,1314],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1350,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1350,1242],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datatap([1350,1314],0,0,350)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1602,1404],0,0,-1)
    {
    Name = "Q1"
    }
   0.pgb([1638,1314],0,62007136,1090)
    {
    Name = "Br1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datatap([1476,1242],0,0,220)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1458,1206],2,0,-1)
    {
    Name = "V2"
    }
   -Wire-([1458,1206],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.pgb([1764,1404],0,62011976,920)
    {
    Name = "Q2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([1638,1404],0,62015040,950)
    {
    Name = "Q1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([1404,1368],0,62017952,1040)
    {
    Name = "I1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([1404,1440],0,62020864,910)
    {
    Name = "I1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([1494,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1368,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pgb([1404,1476],0,62024616,790)
    {
    Name = "I10"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.3"
    Max = "0.05"
    }
   0.datalabel([1494,1476],0,0,-1)
    {
    Name = "I20"
    }
   0.pgb([1530,1476],0,62028424,760)
    {
    Name = "I20"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([1530,1440],0,62031368,870)
    {
    Name = "I2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([1404,1404],0,62034336,990)
    {
    Name = "I1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([1332,1206],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datalabel([1368,1476],0,0,-1)
    {
    Name = "I10"
    }
   0.datalabel([1818,1206],2,0,-1)
    {
    Name = "V3"
    }
   0.datalabel([1854,1242],2,0,-1)
    {
    Name = "V3A"
    }
   0.datalabel([1854,1278],2,0,-1)
    {
    Name = "V3B"
    }
   0.datalabel([1854,1314],2,0,-1)
    {
    Name = "V3C"
    }
   0.datalabel([1980,1242],2,0,-1)
    {
    Name = "V4A"
    }
   0.datalabel([1980,1278],2,0,-1)
    {
    Name = "V4B"
    }
   0.datalabel([1980,1314],2,0,-1)
    {
    Name = "V4C"
    }
   0.datalabel([774,1152],2,0,-1)
    {
    Name = "V3A"
    }
   0.datalabel([810,1152],2,0,-1)
    {
    Name = "V3B"
    }
   0.datalabel([846,1152],2,0,-1)
    {
    Name = "V3C"
    }
   0.datalabel([774,1332],6,0,-1)
    {
    Name = "V4A"
    }
   0.datalabel([810,1332],6,0,-1)
    {
    Name = "V4B"
    }
   0.datalabel([846,1332],6,0,-1)
    {
    Name = "V4C"
    }
   0.datalabel([1854,1368],0,0,-1)
    {
    Name = "I3A"
    }
   0.datalabel([1854,1404],0,0,-1)
    {
    Name = "I3B"
    }
   0.datalabel([1854,1440],0,0,-1)
    {
    Name = "I3C"
    }
   0.datalabel([1854,1476],0,0,-1)
    {
    Name = "I30"
    }
   0.datalabel([1980,1368],0,0,-1)
    {
    Name = "I4A"
    }
   0.datalabel([1980,1404],0,0,-1)
    {
    Name = "I4B"
    }
   0.datalabel([1980,1440],0,0,-1)
    {
    Name = "I4C"
    }
   0.datalabel([1980,1476],0,0,-1)
    {
    Name = "I40"
    }
   0.datalabel([882,1152],2,0,-1)
    {
    Name = "I3A"
    }
   0.datalabel([918,1152],2,0,-1)
    {
    Name = "I3B"
    }
   0.datalabel([954,1152],2,0,-1)
    {
    Name = "I3C"
    }
   0.datalabel([882,1332],2,0,-1)
    {
    Name = "I4A"
    }
   0.datalabel([918,1332],2,0,-1)
    {
    Name = "I4B"
    }
   0.datalabel([954,1332],2,0,-1)
    {
    Name = "I4C"
    }
   0.datalabel([2160,936],4,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([558,1296],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([558,1476],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([2088,1368],0,0,-1)
    {
    Name = "P3"
    }
   0.datalabel([2088,1404],0,0,-1)
    {
    Name = "Q3"
    }
   0.datalabel([2088,1242],0,0,-1)
    {
    Name = "Br3A"
    }
   0.datalabel([2088,1278],0,0,-1)
    {
    Name = "Br3B"
    }
   0.datalabel([2088,1314],0,0,-1)
    {
    Name = "Br3C"
    }
   -Wire-([2214,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2214,1242],0,0,-1)
    {
    Name = "Br4A"
    }
   0.datalabel([2214,1278],0,0,-1)
    {
    Name = "Br4B"
    }
   0.datalabel([2214,1314],0,0,-1)
    {
    Name = "Br4C"
    }
   0.datalabel([2214,1368],0,0,-1)
    {
    Name = "P4"
    }
   0.datalabel([2214,1404],0,0,-1)
    {
    Name = "Q4"
    }
   0.pgb([1890,1242],0,62069952,320)
    {
    Name = "V3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.pgb([1890,1278],0,62072728,390)
    {
    Name = "V3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.pgb([1890,1314],0,62075648,460)
    {
    Name = "V3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.pgb([1890,1368],0,62078560,970)
    {
    Name = "I3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-8.0"
    Max = "8.0"
    }
   0.pgb([1890,1404],0,62081472,860)
    {
    Name = "I3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-8.0"
    Max = "8.0"
    }
   0.pgb([1890,1440],0,62084552,750)
    {
    Name = "I3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-8.0"
    Max = "8.0"
    }
   0.pgb([1890,1476],0,62087464,700)
    {
    Name = "I30"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.2"
    Max = "1.4"
    }
   0.pgb([2016,1242],0,62090376,340)
    {
    Name = "V4a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "200.0"
    }
   0.pgb([2016,1278],0,62093288,430)
    {
    Name = "V4b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "200.0"
    }
   0.pgb([2016,1368],0,62096376,940)
    {
    Name = "I4a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-3.0"
    Max = "3.0"
    }
   0.pgb([2016,1404],0,62103560,800)
    {
    Name = "I4b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-3.0"
    Max = "3.0"
    }
   0.pgb([2016,1440],0,62106184,720)
    {
    Name = "I4c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-3.0"
    Max = "3.0"
    }
   0.pgb([2016,1476],0,62109096,690)
    {
    Name = "I40"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.4"
    Max = "0.05"
    }
   0.pgb([2124,1242],0,62112008,1120)
    {
    Name = "Br3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([2124,1278],0,62114784,1070)
    {
    Name = "Br3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([2124,1314],0,62117760,1020)
    {
    Name = "Br3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([2124,1404],0,62120536,780)
    {
    Name = "Q3"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([2250,1368],0,62123448,850)
    {
    Name = "P4"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   0.pgb([2250,1404],0,62126360,740)
    {
    Name = "Q4"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([2250,1278],0,62129272,1050)
    {
    Name = "Br4b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([2250,1314],0,62132048,1000)
    {
    Name = "Br4c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.datalabel([576,792],0,0,-1)
    {
    Name = "F5"
    }
   0.datalabel([1242,1134],2,0,-1)
    {
    Name = "B4"
    }
   0.pgb([1404,1242],0,62136360,200)
    {
    Name = "V1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([2376,1242],0,62139272,440)
    {
    Name = "V1rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.pgb([2376,1278],0,62142240,490)
    {
    Name = "V2rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   -Wire-([414,630],0,0,-1)
    {
    Vertex="0,0;-144,0"
    }
   -Wire-([954,630],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.datalabel([990,756],0,0,-1)
    {
    Name = "F4"
    }
   0.datalabel([990,738],0,0,-1)
    {
    Name = "FT4"
    }
   -Wire-([1008,630],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.pgb([1638,1368],0,62147984,1010)
    {
    Name = "P1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   0.recorder2_0([450,1404],0,0,1140)
    {
    FName = "stn2"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "2"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V2a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V2b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V2c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I2a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I2b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I2c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   -Wire-([324,1260],0,0,-1)
    {
    Vertex="0,0;0,288"
    }
   -Wire-([720,1260],0,0,-1)
    {
    Vertex="0,0;0,288"
    }
   0.datalabel([2160,882],6,0,-1)
    {
    Name = "Breaker"
    }
   0.datalabel([1098,1152],0,0,-1)
    {
    Name = "Breaker"
    }
   0.unity([1134,1350],0,0,590)
    {
    IType = "2"
    OType = "1"
    }
   0.datalabel([1944,1206],2,0,-1)
    {
    Name = "V4"
    }
   0.mux_array([1152,1422],6,0,600)
    {
    DPath = "0"
    }
   0.datatap([1134,1134],6,0,640)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1170,1134],6,0,630)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1206,1134],6,0,620)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1080,1224],6,0,1240)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1116,1224],6,0,1230)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1152,1224],6,0,1220)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1188,1224],6,0,1210)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1224,1224],6,0,1200)
    {
    Index = "5"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1260,1224],6,0,1190)
    {
    Index = "6"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1188,1224],2,0,-1)
    {
    Name = "FT4"
    }
   -Wire-([1242,1242],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   0.datatap([1080,1476],0,0,900)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1116,1476],0,0,890)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1152,1476],0,0,880)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1188,1476],0,0,840)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1224,1476],0,0,830)
    {
    Index = "5"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1260,1476],0,0,820)
    {
    Index = "6"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1260,1224],2,0,-1)
    {
    Name = "FT6"
    }
   0.datalabel([1224,1476],0,0,-1)
    {
    Name = "F5"
    }
   -Wire-([1242,1458],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   0.datalabel([1188,1476],0,0,-1)
    {
    Name = "F4"
    }
   0.unity([1170,1350],4,0,1100)
    {
    IType = "2"
    OType = "1"
    }
   0.pgb([2124,1368],0,62188408,930)
    {
    Name = "P3"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   0.datatap([1242,1134],6,0,610)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1278,1134],6,0,560)
    {
    Index = "5"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1314,1134],6,0,580)
    {
    Index = "6"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1296,1152],0,0,-1)
    {
    Vertex="0,0;-198,0"
    }
   0.datalabel([1278,1098],2,0,-1)
    {
    Name = "Faulttype"
    }
   -Wire-([1278,1134],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.datalabel([1314,1134],2,0,-1)
    {
    Name = "F_loc"
    }
   -Wire-([1170,1314],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([1206,1350],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1242,1350],2,0,-1)
    {
    Name = "Faulttype"
    }
   0.datalabel([1098,1350],0,0,-1)
    {
    Name = "F_Loc"
    }
   0.var([252,702],3,62199184,60)
    {
    Name = "Ph Angle"
    Group = "SS1"
    Display = "0"
    Max = "180"
    Min = "0.0"
    Value = "0.0"
    Units = "deg"
    Collect = "1"
    }
   0.var([198,702],3,62202280,50)
    {
    Name = "Voltage"
    Group = "SS1"
    Display = "0"
    Max = "500"
    Min = "0.0"
    Value = "230.0"
    Units = "kV"
    Collect = "1"
    }
   0.var([1134,702],5,62205136,90)
    {
    Name = "Voltage"
    Group = "SS2"
    Display = "0"
    Max = "500"
    Min = "0.0"
    Value = "230.0"
    Units = "kV"
    Collect = "1"
    }
   0.var([1080,702],5,62207992,80)
    {
    Name = "Ph Angle"
    Group = "SS2"
    Display = "0"
    Max = "180"
    Min = "-180"
    Value = "20.0"
    Units = "deg"
    Collect = "1"
    }
   0.source3R([234,630],6,0,530)
    {
    Name = "Source1"
    MVA = "100.0 [MVA]"
    Vm = "230.0 [kV]"
    F = "$(f)"
    Tc = "0.05 [s]"
    Ideal = "0"
    ZSeq = "1"
    Imp = "1"
    View = "1"
    details = "1"
    Z1 = "52.9 [ohm]"
    Phi1 = "80.0 [deg]"
    R1p = "1.0 [ohm]"
    X1p = "0.1 [ohm]"
    Z0 = "52.9 [ohm]"
    Phi0 = "80.0 [deg]"
    R0p = "1.0 [ohm]"
    X0p = "0.1 [ohm]"
    P = "S1W"
    Q = "S1Q"
    Ia = ""
    Ib = ""
    Ic = ""
    }
   0.source3R([1098,630],2,0,540)
    {
    Name = "Source2"
    MVA = "100.0 [MVA]"
    Vm = "230.0 [kV]"
    F = "$(f)"
    Tc = "0.05 [s]"
    Ideal = "0"
    ZSeq = "1"
    Imp = "1"
    View = "1"
    details = "1"
    Z1 = "52.9 [ohm]"
    Phi1 = "80.0 [deg]"
    R1p = "1.0 [ohm]"
    X1p = "0.1 [ohm]"
    Z0 = "52.9 [ohm]"
    Phi0 = "80.0 [deg]"
    R0p = "1.0 [ohm]"
    X0p = "0.1 [ohm]"
    P = "S2W"
    Q = "S2Q"
    Ia = ""
    Ib = ""
    Ic = ""
    }
   0.recorder2_0([846,1404],0,0,1080)
    {
    FName = "stn4"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "4"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V2a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V2b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V2c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I2a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I2b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I2c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.datalabel([954,1296],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([954,1476],0,0,-1)
    {
    Name = "Fault"
    }
   0.tpflt([324,720],0,0,1300)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([540,756],0,0,1290)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "1"
    }
   0.tpflt([540,522],0,0,1320)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([828,522],4,0,1310)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([828,756],4,0,1270)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([1026,720],4,0,1280)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   -Wire-([1134,1530],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([1206,1530],0,0,-1)
    {
    Name = "Ron"
    }
   0.pgb([1638,1440],0,62242872,810)
    {
    Name = "PS1"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([1638,1476],0,62245648,730)
    {
    Name = "QS1"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.pgb([1764,1440],0,62248528,770)
    {
    Name = "PS2"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([1764,1476],0,62251440,710)
    {
    Name = "QS2"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   -Bus-([414,486],0,50868816,-1)
    {
    P1 = [0,0]
    P2 = [0,288]
    I = 1
    NAME = BUS1
    BASKV = 0
    IDE = 0
    GL = 0
    BL = 0
    AREA = 1
    ZONE = 0
    VM = 0
    VA = 0
    OWNER = 1
    }
   -Bus-([954,486],0,50869104,-1)
    {
    P1 = [0,0]
    P2 = [0,288]
    I = 1
    NAME = BUS2
    BASKV = 0
    IDE = 0
    GL = 0
    BL = 0
    AREA = 1
    ZONE = 0
    VM = 0
    VA = 0
    OWNER = 1
    }
   0.breaker3([450,738],4,0,660)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B3"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I3A"
    IBRB = "I3B"
    IBRC = "I3C"
    IBR0 = "I30"
    SBRA = "Br3A"
    SBRB = "Br3B"
    SBRC = "Br3C"
    BP = "P3"
    BQ = "Q3"
    BOpen1 = "2"
    BOpen2 = "2"
    BOpen3 = "2"
    P = "0.05273 [MW]"
    Q = "0.0003762 [MVAR]"
    }
   0.breaker3([918,738],0,0,650)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B4"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I4A"
    IBRB = "I4B"
    IBRC = "I4C"
    IBR0 = "I40"
    SBRA = "Br4A"
    SBRB = "Br4B"
    SBRC = "Br4C"
    BP = "P4"
    BQ = "Q4"
    BOpen1 = "2"
    BOpen2 = "2"
    BOpen3 = "2"
    P = "0.05198 [MW]"
    Q = "0.002067 [MVAR]"
    }
   0.pgb([2016,1314],0,62263024,480)
    {
    Name = "V4c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "200.0"
    }
   0.pgb([1638,1242],0,62265992,1170)
    {
    Name = "Br1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   -Sticky-([1404,1098],0)
    {
    Name = ""
    Font = 1
    Bounds = 1404,1098,1512,1134
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "OUTPUT CHANNELS"
    }
   0.mux_array([1152,1278],0,0,1180)
    {
    DPath = "0"
    }
   0.var([1098,1530],0,62270136,520)
    {
    Name = "Rf"
    Group = ""
    Display = "0"
    Max = "50"
    Min = "0.001"
    Value = "0.001"
    Units = ""
    Collect = "1"
    }
   0.annotation([1098,1512],0,0,-1)
    {
    AL1 = "Rf"
    AL2 = ""
    }
   0.recorder2_0([846,1224],0,0,1250)
    {
    FName = "stn3"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "3"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V1a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V1b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V1c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I1a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I1b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I1c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.recorder2_0([450,1224],0,0,1260)
    {
    FName = "stn1"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "1"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V1a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V1b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V1c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I1a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I1b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I1c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.const([198,1188],1,0,120)
    {
    Name = ""
    Value = "10.0"
    }
   0.const([198,1368],1,0,210)
    {
    Name = ""
    Value = "10.0"
    }
   0.var_switch([234,1332],1,62301632,180)
    {
    Name = "en Record2"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.const([612,1188],1,0,140)
    {
    Name = ""
    Value = "10.0"
    }
   0.select([648,1224],6,0,160)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.select([648,1404],6,0,410)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.const([612,1368],1,0,300)
    {
    Name = ""
    Value = "10.0"
    }
   -Wire-([684,1224],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([720,1548],0,0,-1)
    {
    Vertex="0,0;-396,0"
    }
   0.var([288,1260],0,62308968,170)
    {
    Name = "Stop"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.5"
    Units = "s"
    Collect = "1"
    }
   -Wire-([342,1260],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.select([234,1224],6,0,550)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.select([234,1404],6,0,290)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([270,1404],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([144,1260],0,0,-1)
    {
    Vertex="0,0;0,270"
    }
   -Wire-([144,1260],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([144,1440],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([270,1224],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.var_switch([234,1152],1,62316320,110)
    {
    Name = "en Record1"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([648,1152],1,62319040,130)
    {
    Name = "en Record3"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([648,1332],1,62321760,240)
    {
    Name = "en Record4"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   -Wire-([594,1530],0,0,-1)
    {
    Vertex="0,0;-450,0"
    }
   -Wire-([684,1404],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([594,1440],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([594,1260],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([594,1260],0,0,-1)
    {
    Vertex="0,0;0,270"
    }
   -TLine-([576,522],0,55365160,-1)
    {
    Name = "LINE1"
    Date = 1144686074
    Freq = "$(f)"
    Length = "100.0 [km]"
    Dim = 3
    Mode = 1
    Vertex="0,0;18,0;198,0;216,0"
    PageLayer(A/A4,Landscape,16,[597,467],100)
     {
     0.Line_FreDep_Options([738,378],0,50225616,-1)
      {
      FS = "0.5 [Hz]"
      FE = "1.0E6 [Hz]"
      FT = "2000 [Hz]"
      ZMaxP = "20"
      AMaxP = "20"
      ZMaxE = "2 [%]"
      AMaxE = "2 [%]"
      Interp1 = "1"
      Output = "0"
      W1 = "100"
      W2 = "1000"
      W3 = "1"
      Inflen = "0"
      }
     0.Line_Ground([630,702],0,50226728,-1)
      {
      GRRES = "100.0 [ohm*m]"
      GPERM = "1.0"
      EarthForm = "0"
      }
     0.SequenceInfo([234,414],0,55405896,-1)
      {
      Mode = "0"
      X1 = "3.57448095"
      Y1 = "50.7762676"
      X2 = "3.57448095"
      Y2 = "50.7762676"
      X3 = "36.3152201"
      Y3 = "132.647323"
      X4 = "1.0e-005"
      Y4 = "0.000327117946"
      X5 = "0.0"
      Y5 = "0.0"
      X6 = "1.0e-005"
      Y6 = "0.000232266098"
      M1 = "50.9019279149"
      P1 = "85.9732100966"
      M2 = "50.9019279149"
      P2 = "85.9732100966"
      M3 = "137.528569795"
      P3 = "74.6891426178"
      M4 = "0.000327270760373"
      P4 = "88.249012563"
      M5 = "0.0"
      P5 = "0.0"
      M6 = "0.000232481268665"
      P6 = "87.5347062197"
      }
     0.Line_Tower_3_Delta([810,612],0,50227352,-1)
      {
      TName = "3H5"
      Y = "30 [m]"
      Y2 = "5 [m]"
      XC = "10 [m]"
      X = "0 [m]"
      ShuntG = "1.0E-10 [mho/m]"
      SHSag = "0"
      Transp = "1"
      NG = "2"
      ElimGW = "1"
      CDataType = "1"
      CName = "chukar"
      CLName = "..\\conductor.clb"
      RadiusC = "0.0203454 [m]"
      DCResC = "0.03206 [ohm/km]"
      SAGC = "10 [m]"
      NCondB = "1"
      BundSym = "0"
      SHBund = "1"
      BSP = ".4572 [m]"
      GDataType = "1"
      GName = "1/2\"HighStrengthSteel"
      GLName = "..\\conductor.clb"
      RadiusG = "0.0055245 [m]"
      DCResG = "2.8645 [ohm/km]"
      SAGG = "10 [m]"
      YG = "10 [m]"
      XG = "10 [m]"
      XB1 = "-0.1 [m]"
      YB1 = "0.1 [m]"
      XB2 = "-0.1 [m]"
      YB2 = "0.1 [m]"
      XB3 = "-0.1 [m]"
      YB3 = "0.1 [m]"
      XB4 = "-0.1 [m]"
      YB4 = "0.1 [m]"
      XB5 = "-0.1 [m]"
      YB5 = "0.1 [m]"
      XB6 = "-0.1 [m]"
      YB6 = "0.1 [m]"
      XB7 = "-0.1 [m]"
      YB7 = "0.1 [m]"
      XB8 = "-0.1 [m]"
      YB8 = "0.1 [m]"
      XB9 = "-0.1 [m]"
      YB9 = "0.1 [m]"
      XB10 = "-0.1 [m]"
      YB10 = "0.1 [m]"
      NC1 = "1"
      NC2 = "2"
      NC3 = "3"
      NG1 = "4"
      NG2 = "5"
      }
     }
    }
   -TLine-([576,738],0,51273856,-1)
    {
    Name = "LINE2"
    Date = 1144686075
    Freq = "$(f)"
    Length = "100.0 [km]"
    Dim = 3
    Mode = 1
    Vertex="0,0;18,0;198,0;216,0"
    PageLayer(A/A4,Landscape,16,[597,467],100)
     {
     0.Line_FreDep_Options([738,378],0,51275032,-1)
      {
      FS = "0.5 [Hz]"
      FE = "1.0E6 [Hz]"
      FT = "2000 [Hz]"
      ZMaxP = "20"
      AMaxP = "20"
      ZMaxE = "2 [%]"
      AMaxE = "2 [%]"
      Interp1 = "1"
      Output = "0"
      W1 = "100"
      W2 = "1000"
      W3 = "1"
      Inflen = "0"
      }
     0.Line_Ground([630,702],0,51276120,-1)
      {
      GRRES = "100.0 [ohm*m]"
      GPERM = "1.0"
      EarthForm = "0"
      }
     0.SequenceInfo([234,432],0,55446848,-1)
      {
      Mode = "0"
      X1 = "3.57448095"
      Y1 = "50.7762676"
      X2 = "3.57448095"
      Y2 = "50.7762676"
      X3 = "36.3152201"
      Y3 = "132.647323"
      X4 = "1.0e-005"
      Y4 = "0.000327117946"
      X5 = "0.0"
      Y5 = "0.0"
      X6 = "1.0e-005"
      Y6 = "0.000232266098"
      M1 = "50.9019279149"
      P1 = "85.9732100966"
      M2 = "50.9019279149"
      P2 = "85.9732100966"
      M3 = "137.528569795"
      P3 = "74.6891426178"
      M4 = "0.000327270760373"
      P4 = "88.249012563"
      M5 = "0.0"
      P5 = "0.0"
      M6 = "0.000232481268665"
      P6 = "87.5347062197"
      }
     0.Line_Tower_3_Delta([810,612],0,51276752,-1)
      {
      TName = "3H5"
      Y = "30 [m]"
      Y2 = "5 [m]"
      XC = "10 [m]"
      X = "0 [m]"
      ShuntG = "1.0E-10 [mho/m]"
      SHSag = "0"
      Transp = "1"
      NG = "2"
      ElimGW = "1"
      CDataType = "1"
      CName = "chukar"
      CLName = "..\\conductor.clb"
      RadiusC = "0.0203454 [m]"
      DCResC = "0.03206 [ohm/km]"
      SAGC = "10 [m]"
      NCondB = "1"
      BundSym = "0"
      SHBund = "1"
      BSP = ".4572 [m]"
      GDataType = "1"
      GName = "1/2\"HighStrengthSteel"
      GLName = "..\\conductor.clb"
      RadiusG = "0.0055245 [m]"
      DCResG = "2.8645 [ohm/km]"
      SAGG = "10 [m]"
      YG = "10 [m]"
      XG = "10 [m]"
      XB1 = "-0.1 [m]"
      YB1 = "0.1 [m]"
      XB2 = "-0.1 [m]"
      YB2 = "0.1 [m]"
      XB3 = "-0.1 [m]"
      YB3 = "0.1 [m]"
      XB4 = "-0.1 [m]"
      YB4 = "0.1 [m]"
      XB5 = "-0.1 [m]"
      YB5 = "0.1 [m]"
      XB6 = "-0.1 [m]"
      YB6 = "0.1 [m]"
      XB7 = "-0.1 [m]"
      YB7 = "0.1 [m]"
      XB8 = "-0.1 [m]"
      YB8 = "0.1 [m]"
      XB9 = "-0.1 [m]"
      YB9 = "0.1 [m]"
      XB10 = "-0.1 [m]"
      YB10 = "0.1 [m]"
      NC1 = "1"
      NC2 = "2"
      NC3 = "3"
      NG1 = "4"
      NG2 = "5"
      }
     }
    }
   -Wire-([846,738],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Wire-([846,522],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Wire-([522,738],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Sticky-([1044,522],0)
    {
    Name = ""
    Font = 1
    Bounds = 1044,522,1134,558
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SUBSTATION 2"
    }
   -Sticky-([180,522],0)
    {
    Name = ""
    Font = 1
    Bounds = 180,522,270,558
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SUBSTATION 1"
    }
   0.datalabel([2160,900],4,0,-1)
    {
    Name = "Faulttype"
    }
   0.datalabel([2196,918],0,0,-1)
    {
    Name = "V1"
    }
   -Wire-([2232,936],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   -Wire-([2232,882],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   -Wire-([2160,900],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([2196,918],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Sticky-([36,36],0)
    {
    Name = ""
    Font = 1
    Bounds = 36,36,558,216
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
Description: 
- Two Thevinen Impedance sources connected via two 100km transmission lines.
- System voltage is 230kV settable via source equivalents.
- Simulates two substations connected via two transmission lines.
- Six fault positions for full fault control ahead and behind station relays.
- Four breakers are independently timed controlled. (Default is closed) or using sequencer.
- Independent breaker pole tripping is possible."
    }
   .Plots_B1([450,396],0,0,10)
    {
    }
   .Plots_B2([918,396],0,0,20)
    {
    }
   .Controls([2268,918],4,0,570)
    {
    }
   0.multimeter([504,522],0,0,30)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V1"
    P = ""
    Q = ""
    Vrms = "V1rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([504,738],0,0,70)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V3"
    P = ""
    Q = ""
    Vrms = "V3rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([864,738],4,0,100)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V4"
    P = ""
    Q = ""
    Vrms = "V4rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([864,522],4,0,40)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V2"
    P = ""
    Q = ""
    Vrms = "V2rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   -Wire-([2340,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2340,1242],0,0,-1)
    {
    Name = "V1rms"
    }
   -Wire-([2340,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2340,1278],0,0,-1)
    {
    Name = "V2rms"
    }
   -Wire-([2340,1314],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2340,1314],0,0,-1)
    {
    Name = "V3rms"
    }
   -Wire-([2340,1350],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2340,1350],0,0,-1)
    {
    Name = "V4rms"
    }
   -Divider-([18,1026],0)
    {
    Size(2376,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Sticky-([630,36],0)
    {
    Name = ""
    Font = 1
    Bounds = 630,36,1026,144
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
This case uses global substitutions.  To change between 50Hz/60Hz. select Global Substitutions (Ctrl-G).  In the pop-up window, change the value of f to the desired frequency.
"
    }
   }
  }
 }

